---
title: Redirect 403 Forbidden to a different page · Cloudflare Rules docs
description: If origin responded with `403 Forbidden` error code, redirect to
  different page.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Redirects
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/
  md: https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/index.md
---

```js
export default {
  async fetch(request) {
    // Send original request to the origin
    const response = await fetch(request);
    // Check if origin responded with 403 status code
    if (response.status == 403) {
      // If so, redirect to this URL
      const destinationURL = "https://example.com";
      // With this status code
      const statusCode = 301;
      // Serve redirect
      return Response.redirect(destinationURL, statusCode);
    }
    // Otherwise, serve origin's response
    else {
      return response;
    }
  },
};
```
